#include "ISimEntity.h"
#include "SetEntityPositionCommand.h"

namespace SimulationEngine
{

ISimEntity::ISimEntity()
{
	this->AddCommand(new SetEntityPositionCommand(this));
}

ISimEntity::ISimEntity(int entityid)
{
	this->entityid = entityid;
	this->AddCommand(new SetEntityPositionCommand(this));
}

ISimEntity::~ISimEntity()
{
	std::list<ICommand *>::iterator iter;
	iter = commands.begin();
	while (iter!=commands.end())
	{
		ICommand *todestroy = (*iter);
		delete todestroy;
		iter++;
	}
	
}

ICommand *ISimEntity::GetCommand(string commandkey)
{
	std::list<ICommand *>::iterator iter;
	bool found = false;
	ICommand *toreturn=0;
	iter = commands.begin();
	while (!found && iter!=commands.end())
	{
		if (commandkey.compare((*iter)->GetCommandKey())== 0)
		{
			toreturn = (*iter);
			found = true;
		}
		else
			iter++;
	}
	return toreturn;
}

int ISimEntity::GetEntityId()
{
	return entityid;
}

void ISimEntity::AddCommand(ICommand *cmd)
{
	commands.push_back(cmd);
}

}
